USE [TriggerDemoBase]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE TABLE [dbo].[HoldingTable](
	[City] [nvarchar](25) NULL,
	[ZIP] [nvarchar](10) NULL,
	[CompanyName] [nvarchar](95) NULL,
	[Industry] [nvarchar](65) NULL,
	[Title] [nvarchar](77) NULL,
	[State] [nvarchar](10) NULL,
	[ContactName] [nvarchar](32) NULL,
	[ADDRESS] [nvarchar](50) NULL,
	[Id] [int] IDENTITY(1,1) NOT NULL,
PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO

CREATE TABLE [dbo].[DuplicateCheckResult](
	[id] [bigint] IDENTITY(1,1) NOT NULL,
	[StrongDuplicate] [int] NULL,
	[Duplicate] [int] NULL,
	[HoldingId] [int] NOT NULL,
PRIMARY KEY CLUSTERED 
(
	[id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO

ALTER TABLE [dbo].[DuplicateCheckResult]  WITH CHECK ADD  CONSTRAINT [FK_Holding_Duplicate] FOREIGN KEY([HoldingId])
REFERENCES [dbo].[HoldingTable] ([Id])
GO

ALTER TABLE [dbo].[DuplicateCheckResult] CHECK CONSTRAINT [FK_Holding_Duplicate]
GO

CREATE TABLE [dbo].[MasterTable](
	[City] [nvarchar](25) NULL,
	[ZIP] [nvarchar](10) NULL,
	[CompanyName] [nvarchar](95) NULL,
	[Industry] [nvarchar](65) NULL,
	[Title] [nvarchar](77) NULL,
	[State] [nvarchar](10) NULL,
	[ContactName] [nvarchar](32) NULL,
	[ADDRESS] [nvarchar](50) NULL,
	[HoldingId] [int] NULL
) ON [PRIMARY]
GO


